function [error,align_label] = recovery_error(true_label, clusters)


    n = length(true_label);
    labelset = unique(true_label);
    k = length(labelset);

    P = perms(labelset);
    N = size(P, 1);
    confusion = zeros(1, N);
    for i = 1 : N
        for node = 1 : n
            if (true_label(node) ~= P(i, clusters(node)))
                   confusion(i) = confusion(i) + 1;
            end
        end
    end
    error = min(confusion) / n;
    [minValue, minIndex] = min(confusion);
    alignment = P(minIndex, :);

    
    
    % % Create the confusion matrix
    % conf_matrix = confusionmat(true_label, clusters);
    % 
    % % Solve the linear assignment problem (maximize the alignment)
    % alignmentMatrix = munkres(-conf_matrix); % 'munkres' is a MATLAB implementation for LAP
    % [~, alignment] = max(alignmentMatrix, [], 2);
    
    alignedLabels = zeros(size(true_label));
    uniqueLabels = unique(true_label);
    for i = 1:length(uniqueLabels)
        alignedLabels(clusters == uniqueLabels(i)) = uniqueLabels(alignment(i));
    end


    align_label = alignedLabels;
    
    % Compute the recovery error
   % error = sum(1 - (align_label == true_label)) / length(true_label);
    
end